<!DOCTYPE html>
<html lang="en" class="loading">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title><?php echo e($general->sitename($page_title)); ?></title>
    <link rel="icon" href="<?php echo e(get_image(config('constants.logoIcon.path') .'/favicon.png')); ?>" type="image/x-icon">
    <link rel="shortcut icon" type="image/png" href="<?php echo e(get_image(config('constants.logoIcon.path') .'/favicon.png')); ?>"/>

    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-touch-fullscreen" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">

    <?php echo $__env->yieldContent('import-css'); ?>
    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <link href="https://fonts.googleapis.com/css?family=Rubik:300,400,500,700,900%7CMontserrat:300,400,500,600,700,800,900" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/fonts/feather/style.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/fonts/simple-line-icons/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/fonts/font-awesome/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/css/perfect-scrollbar.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/css/prism.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/css/app.css')); ?>">
    <?php echo $__env->make('partials.notify-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/templates/minimul_new/app-assets/css/custom.css')); ?>">

    <?php echo $__env->yieldContent('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/build/css/intlTelInput.css')); ?>">
    <style>
        .intl-tel-input {
            position: relative;
            display: inline-block;
            width: 100%;
        !important;
        }
    </style>
</head>
<body data-col="1-column" class=" 1-column  blank-page blank-page">
<!-- ////////////////////////////////////////////////////////////////////////////-->
<div class="wrapper">
    <section id="regestration">
        <div class="container-fluid">
            <div class="row full-height-vh">
                <div class="col-12 d-flex align-items-center justify-content-center gradient-aqua-marine">
                    <div class="card px-4 py-2 box-shadow-2">
                        <div class="card-header text-center">
                            <h4 class="text-uppercase text-bold-400 grey darken-1"><?php echo app('translator')->get('Sign Up your account'); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="card-block mx-auto">
                                <form action="<?php echo e(route('user.register')); ?>" method="POST" class="account-form" id="recaptchaForm">
                                    <?php echo csrf_field(); ?>
                                    <?php if(isset($reference)): ?>
                                        <div class="form-group">
                                            <input type="text" name="referBy" class="form-control form-control-lg" id="referenceBy"
                                                   value="<?php echo e($reference); ?>" placeholder="<?php echo app('translator')->get('Reference BY'); ?>" readonly/>
                                        </div>
                                    <?php endif; ?>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" class="form-control form-control-lg" id="InputFirstname" name="firstname"
                                                   placeholder="<?php echo app('translator')->get('First Name'); ?>" value="<?php echo e(old('firstname')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" class="form-control form-control-lg" id="lastname" name="lastname"
                                                   placeholder="<?php echo app('translator')->get('Last Name'); ?>" value="<?php echo e(old('lastname')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="text" id="exampleInputUsername" name="username" value="<?php echo e(old('username')); ?>"
                                                   class="form-control form-control-lg" placeholder="<?php echo app('translator')->get('Username'); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="email" class="form-control form-control-lg" id="email" name="email"
                                                   placeholder="<?php echo app('translator')->get('E-mail Address'); ?>" value="<?php echo e(old('email')); ?>" required="">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="hidden" id="track" name="country_code">
                                            <input type="tel" class="form-control pranto-control form-control-lg" id="phone" name="mobile"
                                                   value="<?php echo e(old('mobile')); ?>" placeholder="<?php echo app('translator')->get('Your Contact Number'); ?>">
                                        </div>
                                    </div>
                                    <div class="form-group d-none">
                                        <input type="text" name="country" id="country" value="<?php echo e(old('country')); ?>"
                                               class="form-control">
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="password" name="password" value="<?php echo e(old('password')); ?>" class="form-control form-control-lg"
                                                   placeholder="<?php echo app('translator')->get('Password'); ?>">
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <input type="password" name="password_confirmation" class="form-control form-control-lg"
                                                   placeholder="<?php echo app('translator')->get('Retype Password'); ?>">
                                        </div>
                                    </div>

                                    <div class="form-group text-center">
                                        <input type="submit" id="recaptcha" class="btn btn-danger px-4 py-2 text-uppercase white font-small-4 box-shadow-2 border-0" value="<?php echo app('translator')->get('SIGN UP'); ?>">
                                    </div>

                                    <div class="form-group">
                                        <?php echo app('translator')->get("Already have an account yet?"); ?>
                                        <a href="<?php echo e(route('user.login')); ?>" class=""><?php echo app('translator')->get('Sign In'); ?></a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="//code.jquery.com/jquery-3.4.1.min.js"></script>
    <?php echo recaptcha() ?>
    <!--Login Page Ends-->
</div>
<!-- ////////////////////////////////////////////////////////////////////////////-->

<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/core/jquery-3.3.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/core/popper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/core/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/perfect-scrollbar.jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/prism.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/jquery.matchHeight-min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/screenfull.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/vendors/js/pace/pace.min.js')); ?>"></script>
<!-- BEGIN VENDOR JS-->
<!-- BEGIN CONVEX JS-->
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/js/app-sidebar.js')); ?>"></script>
<script src="<?php echo e(asset('assets/templates/minimul_new/app-assets/js/notification-sidebar.js')); ?>"></script>
<!-- END CONVEX JS-->

<?php echo $__env->make('partials.notify-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldContent('load-js'); ?>
<?php echo $__env->yieldContent('script'); ?>

<script src="<?php echo e(asset('assets/admin/build/js/intlTelInput.js')); ?>"></script>

<script>
    $('select[name=country]').val("<?php echo e(old('country')); ?>");
</script>

<script>
    $("#phone").on("countrychange", function (e, countryData) {
        // do something with countryData

        var data = $(this).val('+' + countryData.dialCode)
        $('#track').val(data);
        var country = countryData.name;
        var country = country.split('(')[0];
        $('#country').val(country);
    });
    $("#phone").intlTelInput({
        geoIpLookup: function (callback) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                callback(countryCode);
            });
        },

        // hiddenInput: "full_number",
        initialCountry: "auto",
        utilsScript: "<?php echo e(asset('assets/admin/build/js/utils.js')); ?>"
    });
</script>

<?php echo $__env->yieldPushContent('js'); ?>

<?php
    if($plugins[0]->status == 1){
        $appKeyCode = $plugins[0]->shortcode->app_key->value;
        $twakTo = str_replace("{{app_key}}",$appKeyCode,$plugins[0]->script);
        echo $twakTo;
    }
?>
</body>
</html>
<?php /**PATH /home/ectinternational/goldenage.club/resources/views/templates/minimal/user/auth/register.blade.php ENDPATH**/ ?>