<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($general->sitename($page_title)); ?></title>
    <!-- favicon -->
    <link rel="icon" href="<?php echo e(get_image(config('constants.logoIcon.path') .'/favicon.png')); ?>" type="image/x-icon">
    <link rel="shortcut icon" type="image/png" href="<?php echo e(get_image(config('constants.logoIcon.path') .'/favicon.png')); ?>"/>
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- fontawesome css link -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.2/css/all.css">
    <!-- bootstrap css link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/templates/basic/css/bootstrap.min.css')); ?>">
    <?php echo $__env->yieldContent('import-css'); ?>
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <!-- animate.css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/templates/basic/css/animate.css')); ?>">
    <!-- owl carousel css link -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/templates/basic/css/owl.carousel.min.css')); ?>">
    <?php echo $__env->make('partials.notify-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- main style css link -->
    

    <link rel="stylesheet" href="<?php echo e(asset('assets/templates/basic/css/style.php')); ?>?color=<?php echo e($general->bclr); ?>&secondColor=<?php echo e($general->sclr); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body >




<header class="inner-page-header">
    <div class="inner-page-header-shape"><img src="<?php echo e(asset('assets/templates/basic/images/ami.png')); ?>" alt="image"></div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="inner-page-header-content">

                    <a href="<?php echo e(url('/')); ?>">
                        <img src="<?php echo e(get_image(config('constants.logoIcon.path') .'/logo.png')); ?>" alt="image">
                    </a>

                    <div class="login-area">
                        <?php if(auth()->guard()->guest()): ?>
                        <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                        <a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a>
                        <?php else: ?>
                        <a href="<?php echo e(route('user.logout')); ?>" class="mb-5"><?php echo app('translator')->get('Sign Out'); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>


<div class="nav-box-area mt-5">
    <div class="container">
        <div class="row text-center">
            <div class="col-lg-2 col-md-4 col-6">
                <a href="<?php echo e(route('home')); ?>">
                    <div class="box">
                        <p> <?php echo app('translator')->get('Home'); ?> </p>
                        <i class="fas fa-home"></i>
                    </div>
                </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6">
                <a href="<?php echo e(route('home.about')); ?>">
                    <div class="box">
                        <p> <?php echo app('translator')->get('About Us'); ?> </p>
                        <i class="fas fa-address-card"></i>
                    </div>
                </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6">
                <a href="<?php echo e(route('home.faq')); ?>">
                    <div class="box">
                        <p> <?php echo app('translator')->get('FAQ'); ?> </p>
                        <i class="fas fa-comments"></i>
                    </div>
                </a>
            </div>
            <div class="col-lg-2 col-md-4 col-6">
                <a href="<?php echo e(route('home.contact')); ?>">
                    <div class="box">
                        <p> <?php echo app('translator')->get('Contact'); ?> </p>
                        <i class="fas fa-envelope"></i>
                    </div>
                </a>
            </div>



            <?php $__currentLoopData = $company_policy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-2 col-md-4 col-6">
                    <a href="<?php echo e(route('home.policy',[$policy, str_slug($policy->value->title)])); ?>">
                        <div class="box">
                            <p> <?php echo e(__($policy->value->title)); ?> </p>
                            <i class="fas fa-pen-square"></i>
                        </div>
                    </a>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>




            <div class="col-lg-2 col-md-4 col-6">
                <a href="<?php echo e(route('home.rules')); ?>">
                    <div class="box">
                        <p> <?php echo app('translator')->get('Rules'); ?> </p>
                        <i class="fas fa-newspaper"></i>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>


<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->make(activeTemplate().'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- jquery -->
<script src="<?php echo e(asset('assets/templates/basic/js/jquery-3.3.1.min.js')); ?>"></script>
<!-- migarate-jquery -->
<script src="<?php echo e(asset('assets/templates/basic/js/jquery-migrate-3.0.0.js')); ?>"></script>
<!-- bootstrap js -->
<script src="<?php echo e(asset('assets/templates/basic/js/bootstrap.min.js')); ?>"></script>
<?php echo $__env->yieldContent('import-js'); ?>
<!-- owl-carousel js -->
<script src="<?php echo e(asset('assets/templates/basic/js/owl.carousel.min.js')); ?>"></script>
<!-- particle js -->
<script src="<?php echo e(asset('assets/templates/basic/js/particles.js')); ?>"></script>
<!-- main -->
<script src="<?php echo e(asset('assets/templates/basic/js/main.js')); ?>"></script>

<?php echo $__env->make('partials.notify-js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldContent('script'); ?>
<?php echo $__env->yieldPushContent('js'); ?>


</body>
</html>
<?php /**PATH /home/ectinternational/goldenage.club/resources/views/templates/minimal/layouts/form.blade.php ENDPATH**/ ?>