<?php $__env->startSection('content'); ?>

    <section id="basic-form-layouts">
        <div class="row">
            <div class="col-10">
                <h2 class="content-header"><?php echo e(__($page_title)); ?></h2>
            </div>
            <div class="col-2">
                <a href="<?php echo e(route('user.ticket')); ?>" class="btn btn-info pull-right mb-0 mt-2" data-toggle="tooltip" data-placement="top" title="<?php echo app('translator')->get('My Support Ticket'); ?>">
                    <i class="fa fa-eye"></i> <?php echo app('translator')->get('See All'); ?>
                </a>
            </div>
        </div>

        <div class="row match-height">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title-wrap bar-warning">

                        </div>
                    </div>
                    <div class="card-body">
                        <div class="px-3">

                            <form  action="<?php echo e(route('user.ticket.store')); ?>" role="form" method="post" enctype="multipart/form-data" id="recaptchaForm">
                                <?php echo csrf_field(); ?>
                                <div class="row ">
                                    <div class="form-group col-md-6">
                                        <label for="name"><?php echo app('translator')->get('Name'); ?></label>
                                        <input type="text"  name="name" value="<?php echo e($user->firstname . ' '.$user->lastname); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Enter Name'); ?>" required readonly>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="email"><?php echo app('translator')->get('Email address'); ?></label>
                                        <input type="email"  name="email" value="<?php echo e($user->email); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Enter your Email'); ?>" required readonly>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label for="website"><?php echo app('translator')->get('Subject'); ?></label>
                                        <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Subject'); ?>" >
                                    </div>

                                </div>

                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label for="department"><?php echo app('translator')->get('Department'); ?></label>
                                        <select class="form-control required" name="department" required>
                                            <?php $__currentLoopData = $topics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($topic->id); ?>"><?php echo e($topic->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="priority"><?php echo app('translator')->get('Priority'); ?></label>
                                        <select class="form-control required" name="priority" required>
                                            <option value="medium"><?php echo app('translator')->get('Medium'); ?></option>
                                            <option value="high"><?php echo app('translator')->get('High'); ?></option>
                                            <option value="low"><?php echo app('translator')->get('Low'); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-12 form-group">
                                        <label for="inputMessage"><?php echo app('translator')->get('Message'); ?></label>
                                        <textarea name="message" id="inputMessage" rows="12" class="form-control"><?php echo e(old('message')); ?></textarea>
                                    </div>
                                </div>

                                <div class="row form-group">
                                    <div class="col-sm-12">
                                        <label for="inputAttachments"><?php echo app('translator')->get('Attachments'); ?></label>
                                    </div>
                                    <div class="col-sm-9 file-upload">
                                        <input type="file" name="attachments[]" id="inputAttachments" class="form-control" />
                                        <div id="fileUploadsContainer"></div>
                                    </div>



                                    <div class="col-sm-3">
                                        <button type="button" class="btn btn-primary" onclick="extraTicketAttachment()">
                                            <i class="fa fa-plus"></i> <?php echo app('translator')->get('Add More'); ?>
                                        </button>
                                    </div>
                                    <div class="col-sm-12 ticket-attachments-message text-muted">
                                        <?php echo app('translator')->get("Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx"); ?>
                                    </div>
                                </div>

                                <div class="row form-group justify-content-center">
                                    <div class="col-md-6">
                                        <button class="btn btn-success bg-3 btn-block text-center mt-3" type="submit" id="recaptcha" ><i class="fa fa-paper-plane"></i>&nbsp;<?php echo app('translator')->get('Submit Now'); ?></button>
                                    </div>


                                    <div class="col-md-6">
                                        <button class=" btn btn-danger btn-block mt-3" type="button" onclick="formReset()">&nbsp;<?php echo app('translator')->get('Cancel'); ?></button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->


    <?php if($plugins[2]->status == 1): ?>
        <script src="//code.jquery.com/jquery-3.4.1.min.js"></script>
        <?php echo recaptcha() ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('load-js'); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>
        function extraTicketAttachment() {
            $("#fileUploadsContainer").append('<input type="file" name="attachments[]" class="form-control form-control-lg mt-2" required />')
        }
        function formReset() {
            window.location.href = "<?php echo e(url()->current()); ?>"
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make(activeTemplate() .'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ectbest/ecoshop.top/core/resources/views/templates/minimal/user/support/sendSupportTicket.blade.php ENDPATH**/ ?>