@extends(activeTemplate() .'layouts.user')

@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-12">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
    </div>

    <section id="simple-table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-block table-responsive table-responsive-xl table-responsive-lg table-responsive-md table-responsive-sm">
                            <table class="table table-striped">
                                <thead class="thead-dark">
                                <tr>
                                    <th scope="col">@lang('Transaction ID')</th>
                                    <th scope="col">@lang('Gateway')</th>
                                    <th scope="col">@lang('Amount')</th>
                                    <th scope="col">@lang('Time')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($deposits) >0)
                                    @foreach($deposits as $k=>$data)
                                        <tr>
                                            <td data-label="#@lang('Trx')">{{$data->trx}}</td>
                                            <td data-label="@lang('Gateway')">{{ $data->gateway->name   }}</td>
                                            <td data-label="@lang('Amount')">
                                                <strong>{{formatter_money($data->amount)}} {{$general->cur_text}}</strong>
                                            </td>
                                            <td data-label="@lang('Time')">
                                                <i class="fa fa-calendar"></i> {{date(' d M, Y ', strtotime($data->created_at))}}
                                                <i class="fa fa-clock-o pl-1"></i> {{date('h:i A', strtotime($data->created_at))}}
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="4"> @lang('No results found')!</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                            {{$deposits->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->
@endsection


@section('load-js')
@stop
@section('script')

@endsection
