

<?php $__env->startSection('panel'); ?>
<div class="row">

    <div class="col-lg-12">
        <div class="card">
            <div class="table-responsive table-responsive-xl">
                <table class="table align-items-center table-light">
                    <thead>
                        <tr>
                            <th scope="col">Date</th>
                            <th scope="col">TRX</th>
                            <th scope="col">Username</th>
                            <th scope="col">Type</th>
                            <th scope="col">Amount</th>
                            <th scope="col">Charge</th>
                            <th scope="col">Total</th>
                            <th scope="col">Detail</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e(show_datetime($trx->created_at)); ?></td>
                            <td class="font-weight-bold"><?php echo e(strtoupper($trx->trx)); ?></td>                            
                            <td><a href="<?php echo e(route('admin.users.detail', $trx->user->id)); ?>"><?php echo e($trx->user->username); ?></a></td>
                            <td>
                                <?php if($trx->type == 'deposit'): ?>
                                <span class="badge badge-primary"><?php echo e($trx->type); ?></span>
                                <?php elseif($trx->type == 'withdraw'): ?>
                                <span class="badge badge-secondary"><?php echo e($trx->type); ?></span>
                                <?php endif; ?>
                            </td>
                            <td class="budget"><?php echo e($general->cur_text); ?><?php echo e(formatter_money($trx->main_amo)); ?></td>
                            <td class="budget text-danger"><?php echo e($general->cur_text); ?><?php echo e(formatter_money($trx->charge)); ?></td>
                            <td class="budget"><?php echo e($general->cur_text); ?><?php echo e(formatter_money($trx->amount)); ?></td>
                            <td><?php echo e($trx->title); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-muted text-center" colspan="100%"><?php echo e($empty_message); ?></td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer py-4">
                <nav aria-label="...">
                    <?php echo e($transactions->links()); ?>

                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<?php if(request()->routeIs('admin.users.transactions')): ?>
<form action="" method="GET" class="form-inline">
    <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="TRX" value="<?php echo e($search ?? ''); ?>">
        <div class="input-group-append">
            <button class="btn btn-success" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>
<?php else: ?>
<form action="<?php echo e(route('admin.report.transaction.search')); ?>" method="GET" class="form-inline">
    <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="TRX / Username" value="<?php echo e($search ?? ''); ?>">
        <div class="input-group-append">
            <button class="btn btn-success" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ectbest/ecoshop.top/core/resources/views/admin/reports/transactions.blade.php ENDPATH**/ ?>