@extends(activeTemplate() .'layouts.user')

@section('content')

    <!-- ========User-Panel-Section Starte Here ========-->
    <div class="row">
        <div class="col-10">
            <h2 class="content-header">{{__($page_title)}}</h2>
        </div>
        <div class="col-2">
            <a href="{{route('user.ticket.open') }}" class="btn btn-info pull-right mb-0 mt-2" data-toggle="tooltip" data-placement="top" title="@lang('Open New Support Ticket')">
                <i class="fa fa-plus"></i> @lang('Create')
            </a>
        </div>
    </div>

    <section id="simple-table">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-block table-responsive table-responsive-xl table-responsive-lg table-responsive-md table-responsive-sm">
                            <table class="table table-striped">
                                <thead class="thead-dark">
                                <tr>
                                    <th scope="col">@lang('SL')</th>
                                    <th scope="col">@lang('Date')</th>
                                    <th scope="col">@lang('Ticket Number')</th>
                                    <th scope="col">@lang('Subject')</th>
                                    <th scope="col">@lang('Status')</th>
                                    <th scope="col">@lang('Action')</th>
                                </tr>
                                </thead>
                                <tbody>
                                @if(count($supports) >0)
                                    @foreach($supports as $key => $support)
                                        <tr>
                                            <td data-label="@lang('SL')">{{ ++$key }}</td>
                                            <td data-label="@lang('Date')">{{ $support->created_at->format('d M, Y h:i A') }}</td>
                                            <td data-label="@lang('Ticket')">#{{ $support->ticket }}</td>
                                            <td data-label="@lang('Subject')">{{ $support->subject }}</td>
                                            <td data-label="@lang('Status')">
                                                @if($support->status == 0)
                                                    <span class="badge badge-primary">@lang('Open')</span>
                                                @elseif($support->status == 1)
                                                    <span class="badge badge-success "> @lang('Answered')</span>
                                                @elseif($support->status == 2)
                                                    <span class="badge badge-info"> @lang('Customer Replied')</span>
                                                @elseif($support->status == 3)
                                                    <span class="badge badge-danger ">@lang('Closed')</span>
                                                @endif
                                            </td>

                                            <td data-label="@lang('Action')">
                                                <a href="{{ route('user.message', $support->ticket) }}" class="btn btn-primary btn-sm">
                                                    <i class="fa fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="6"> @lang('No results found')!</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>

                            {{$supports->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ========User-Panel-Section Ends Here ========-->
@endsection


@section('load-js')

@stop
@section('script')

@endsection
